<h5 class="m_tabdescripton"><?php echo _e('WooCommerce Stock Manager Section', 'motif_stock_manager'); ?></h5>

<div class="col-md-2">
	<label for="m_sorting_prostock"><?php echo _e('Products Sorting:', 'motif_stock_manager'); ?></label>
</div>
<div class="col-md-4">
	<div class="form-group">
		<select id="m_sorting_prostock" class="form-control" onchange="m_srotingstock_p(this.value)">
	   		<option value="ID:ASC" select="selected"><?php echo _e('Most Recent (By ID)', 'motif_stock_manager'); ?></option>
	   		<option value="post_title:ASC"><?php echo _e('Product Title: A to Z', 'motif_stock_manager'); ?></option>
	   		<option value="post_title:DESC"><?php echo _e('Product Title: Z to A', 'motif_stock_manager'); ?></option>
	   		<option value="post_date:ASC"><?php echo _e('Product Date: A to Z', 'motif_stock_manager'); ?></option>
	   		<option value="post_date:DESC"><?php echo _e('Product Date: Z to A', 'motif_stock_manager'); ?></option>
	   	</select>
	</div>
</div>
<div class="col-md-2">
	<label for="s"><?php echo _e('Search By Name', 'motif_stock_manager'); ?></label>
</div>
<div class="col-md-4">
	<div class="form-group">
		<form action="" class="form-inline">
			<input type="hidden" name="page" value="motif-stock-manger.php">
			<input type="text" name="s" class="form-control" value="<?php echo esc_attr($search); ?>">
			
		</form>
	</div>
</div>
<div class="col-md-2">
	<label for="s"><?php echo _e('Search By Category', 'motif_stock_manager'); ?></label>
</div>
<div class="col-md-4">
	<div class="form-group">
		<form action="" class="form-inline">
			<input type="hidden" name="page" value="motif-stock-manger.php">
			<select onchange="this.form.submit()" name="product_cat" class="form-control">
				<?php $catTerms = get_terms('product_cat', array('hide_empty' => 0, 'orderby' => 'ASC')); ?>
					<option value=""><?php esc_html_e('Search by product category'); ?></option>
			        <?php foreach($catTerms as $catTerm) : ?>
			        <option <?php selected( $search_cat , $catTerm->slug); ?> value="<?php echo $catTerm->slug; ?>"><?php echo $catTerm->name; ?></option>
			    <?php endforeach; ?>
		    </select>    
		</form>
	</div>
</div>
<div class="col-md-2">
	<label for="s"><?php echo _e('Export Search Products', 'motif_stock_manager'); ?></label>
</div>
<div class="col-md-4">
	<div class="form-group">
		<button type="button" class="export_search btn button" id="export-to-excel"><?php esc_html_e('Export Search Result', ''); ?></button>
	</div>
</div>
<div class="m_lineloader"></div>
<!-- exporter -->
<form action="" method="post" id="export-form">
	<input type="hidden" value='' id='hidden-type' name='ExportType' />
</form>
<?php

if(isset($_POST["ExportType"]) && isset($_GET['product_cat']) && $_GET['product_cat'] != '') {
	$taxonomy = 'product_cat';

	$args = array(
	  	'posts_per_page' => -1,
	  	'post_type'   => 'product',
	  	'order'=> 'ASC',
		'orderby' => 'title',
		'tax_query'       => array( array(
	        'taxonomy' => $taxonomy,
	        'field'    => 'slug',
	        'terms'    => $_GET['product_cat'],
	    )),
	);

	$products = get_posts( $args );

	foreach ($products as $key => $product) {
		$product = wc_get_product($product->ID);

		$dataArray[] = array(
			$product->get_ID(),
			$product->get_title(),
			$product->get_stock_quantity()
		);
	}
	ob_end_clean();
	$columnHeader = '';  
	$columnHeader = "Product ID" . "\t" . "Product Name" . "\t" . "Stock Quantity" . "\t";  
	$setData = ''; 

	foreach ($dataArray as $key => $products) {
	    $rowData = '';  
	    foreach ($products as $product) {  
	        $product = ' ' . $product . ' ' . "\t";  
	        $rowData .= $product;  
	    }  
	    $setData .= trim($rowData) . "\n";  
	}   

	$filename = "product_data_export_".date('Ymd') . ".xls";
	header("Content-Type: application/octet-stream"); 
	header("Content-Disposition: attachment; filename=".$filename."");
	header("Pragma: no-cache");  
	header("Expires: 0");
	echo ucwords($columnHeader) . "\n" . $setData . "\n";

	exit();
} ?>

<table class="table table-hover table-bordered">
	<thead>
	    <tr>
	    	<th><?php echo _e('Product ID', 'motif_stock_manager'); ?></th>
	    	<th><?php echo _e('Product Type', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Thumbnail', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Sku', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Name', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Regular Price', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Sale Price', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Weight', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Manage Stock', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Stock Status', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Stock', 'motif_stock_manager'); ?></th>
	      	<th><?php echo _e('Save', 'motif_stock_manager'); ?></th>
	    </tr>
	</thead>
	<tbody id="msm_mbody">
	    
    	<?php 

    	if(isset($_GET['product_cat']) && $_GET['product_cat'] !='') {
    		
    		$taxonomy = 'product_cat';

    		$args = array(
			  	'posts_per_page' => -1,
			  	'post_type'   => 'product',
			  	'order'=> 'ASC',
				'orderby' => 'title',
				'tax_query'       => array( array(
		            'taxonomy' => $taxonomy,
		            'field'    => 'slug',
		            'terms'    => $_GET['product_cat'],
		        )),
			);

    	} else if(isset($search) && $search !='') {
    		$args = array(
			  	'posts_per_page' => -1,
			  	'post_type'   => 'product',
			  	'order'=> 'ASC',
				'orderby' => 'title',
				"s" => esc_attr( $search ),
				'search_columns'	=> array(
					'post_title',
					'post_name',
				),
			);
    	} else {
    		$args = array(
			  	'posts_per_page' => -1,
			  	'post_type'   => 'product',
			  	'order'=> 'ASC',
				'orderby' => 'title',
				"s" => esc_attr( $search ),
				'search_columns'	=> array(
					'post_title',
					'post_name',
				),
			);
    	}
		
		$products = get_posts( $args );

		$sr = 1;
		
		foreach ($products as $product) { 

		$product = wc_get_product( $product->ID ); ?>

		    <tr>
		    	<td class="mo_proid">
		      		<?php echo $product->get_id(); ?>		
		      	</td>

		      	<td class="mo_protype">
		      		<?php if ($product->get_type() == "variable") : 

		      			$available_variations = $product->get_available_variations(); ?>

		      			<?php esc_html_e('Variable'.' ('.count($available_variations).')', ''); ?>		

		      			<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
		      			<div class="item-type-wrap item-type-wrap-<?php echo $product->get_id(); ?>">
		      				<form id="product-varition<?php echo $product->get_id(); ?>">
		      				<table>
		      					<thead>
		      						<tr>
		      							<td>Product ID</td>
		      							<td>Product Name</td>
		      							<td>Product Variation</td>
		      							<td>Stock</td>
		      							<td>Manage Stock</td>
		      							<td>Stock Status</td>
		      							<td>Sku</td>
		      							<td>Sale Price</td>
		      							<td>Regular Price</td>
		      						</tr>
		      					</thead>
		      					<tbody>
			      					<?php $i= 0; foreach ($available_variations as $key => $value) { 
			      						$variation = wc_get_product($value['variation_id']); ?>
		      							<tr value="<?php echo $value['variation_id']; ?>">
				      						<td>
				      							<?php echo $value['variation_id']; ?>
				      							<input type="hidden" name="mo_variation[<?php echo $i; ?>][variation_id]" value="<?php echo $value['variation_id']; ?>">
				      						</td>
				      						<td>
				      							<?php $product = wc_get_product( $variation->get_parent_id() ); 
				      								 echo $product->get_title();
				      							?>
				      						</td>
				      						<td>
				      							<?php echo $variationName = implode(",", $variation->get_variation_attributes()); ?>
				      						</td>
				      						<td>
				      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_stock]" value="<?php echo $variation->get_stock_quantity(); ?>">
				      						</td>
				      						<td>
				      							<select name="mo_variation[<?php echo $i; ?>][variation_stock_manage]" class="m_managev_stock_<?php echo $product->get_id(); ?>">
										      		<?php if($variation->get_manage_stock() == "yes") { ?>
										      			<option selected="selected" value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
										              	<option value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
										      		<?php } else if($variation->get_manage_stock() == "no") { ?>
										      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
										              	<option value="no" selected="selected"><?php echo _e('No', 'motif_stock_manager'); ?></option>
										      		<?php } else { ?>
										      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
										              	<option selected="selected" value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
										      		<?php } ?>
									            </select>
				      						</td>
				      						<td>
				      							<select name="mo_variation[<?php echo $i; ?>][variation_stock_status]" class="m_stockv_status_<?php echo $product->get_id(); ?>">
										      		<?php if($variation->get_stock_status() == "instock") { ?>
										      			<option selected="selected" value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
										      			<option value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
										      			<?php  } else if($variation->get_stock_status() == "outofstock") { ?>
										      			<option value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
										      			<option selected="selected" value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
										      		<?php } ?>
									      		</select>
				      						</td>
				      						<td>
				      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_sku]" value="<?php echo $variation->get_sku(); ?>">
				      						</td>
				      						<td>
				      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_regular_price]" value="<?php echo $variation->get_regular_price(); ?>">
				      						</td>
				      						<td>
				      							<input  type="text" name="mo_variation[<?php echo $i; ?>][variation_sale_price]" value="<?php echo $variation->get_sale_price(); ?>">
				      						</td>
				      					</tr>
			      					<?php $i++; } ?>
		      					</tbody>
		      				</table>
		                    <span class="btn btn-primary btn-xs item-post-tpe-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
		                    <span class="btn btn-danger btn-xs item-type-wrap-button-close">Close</span>
		                    </form>
		                </div>

		      		<?php else: ?>

		      			<?php esc_html_e('Simple', ''); ?>

		      		<?php endif; ?>		
		      	</td>

		      	<td class="mo_proimage">
		      		<img class="mtf-img" src="<?php echo get_the_post_thumbnail_url( $product->get_id()); ?>">
		      	</td>

		      	<td class="mo_prosku">
		      		<span class="item-sku-text-<?php echo $product->get_id(); ?>"><?php echo $product->get_sku(); ?></span>
		      		<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
		      		<div class="item-sku-wrap item-sku-wrap-<?php echo $product->get_id(); ?>">
	                    <input type="text" name="sku[<?php echo $product->get_id(); ?>]" class="item-sku sku_<?php echo $product->get_id(); ?>" value="<?php echo $product->get_sku(); ?>">
	                    <span class="btn btn-primary btn-xs item-sku-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
	                    <span class="btn btn-danger btn-xs item-sku-button-close">Close</span>
	                </div>
		      	</td>

		      	<td class="mo_proname">
		      		<a target="_blank"  href="<?php echo admin_url('/post.php?post='.$product->get_id().'&action=edit'); ?>" class="item-post-link-<?php echo $product->get_id(); ?>">
		      			<?php echo $product->get_name(); ?>	
		      		</a>
		      		<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
		      		<div class="item-post-title-wrap item-post-title-wrap-<?php echo $product->get_id(); ?>">
	                    <input type="text" name="item-post-title" class="item-post-title item-post-title-<?php echo $product->get_id(); ?>" value="<?php echo $product->get_name(); ?>">
	                    <span class="btn btn-primary btn-xs item-post-title-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
	                    <span class="btn btn-danger btn-xs item-post-title-button-close">Close</span>
	                </div>
		      	</td>

		      	<td class="mo_prorprice">
		      		<input class="m_number_f m_regular_price_<?php echo $product->get_id(); ?>" type="number" min="0.01" step="0.01" name="m_regular_price" value="<?php echo $product->get_regular_price(); ?>">
		      	</td>

		      	<td class="mo_prosprice">
		      		<input class="m_number_f m_sales_price_<?php echo $product->get_id(); ?>" type="number" min="0.01" step="0.01" name="m_sale_price" value="<?php echo $product->get_sale_price(); ?>">
		      	</td>

		      	<td class="mo_proweight">
		      		<input class="m_number_f weight_<?php echo $product->get_id(); ?> wc_input_decimal" name="m_weight" value="<?php echo $product->get_weight(); ?>">
		      	</td>

		      	<td class="mo_promngstock">
		      		<select class="m_manage_stock_<?php echo $product->get_id(); ?>">
		      		<?php if($product->get_manage_stock() == "yes") { ?>
		      			<option selected="selected" value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
		              	<option value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
		      		<?php } else if($product->get_manage_stock() == "no") { ?>
		      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
		              	<option value="no" selected="selected"><?php echo _e('No', 'motif_stock_manager'); ?></option>
		      		<?php } else { ?>
		      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
		              	<option selected="selected" value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
		      		<?php } ?>
		            </select>
		      	</td>

		      	<td class="mo_stockstatus">
		      		<select class="m_stock_status_<?php echo $product->get_id(); ?>">
		      		<?php if($product->get_stock_status() == "instock") { ?>
		      			<option selected="selected" value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
		      			<option value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
		      			<?php  } else if($product->get_stock_status() == "outofstock") { ?>
		      			<option value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
		      			<option selected="selected" value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
		      		<?php } ?>
		      		</select>
		      	</td>

		    	<td class="mo_proquantity" style="background-color: <?php if($product->get_stock_quantity() == '0' || $product->get_stock_quantity() == '') echo $setings['outs']; else if ($product->get_stock_quantity() <='5') echo $setings['lows']; else if ( $product->get_stock_quantity() >='6' ) echo $setings['ins'];  else echo ""; ?>;">
		    		<input class="m_number_f m_stock_<?php echo $product->get_id(); ?>" type="number" name="m_sale_price" value="<?php echo $product->get_stock_quantity(); ?>">
		    	</td>

		    	<td>
		    		<input type="button" class="btn btn-primary btn-xs save-line-product" data-product="<?php echo $product->get_id(); ?>" value="Save">
		    		<input type="hidden" name="msm-ajax-nonce-<?php echo $product->get_id(); ?>" class="msm-ajax-nonce_<?php echo $product->get_id(); ?>" value="<?php echo wp_create_nonce( 'msm-ajax-nonce-'.$product->get_id() ); ?>" />
		    	</td>
		    </tr>
		    
		<?php $sr++; } ?>
	    
	  </tbody>
</table>
<div class="holder"></div>

<script type="text/javascript">
	
	jQuery(document).ready(function() {
		jQuery('#export-to-excel').bind("click", function() {
		var target = jQuery(this).attr('id');
		console.log(target);
		switch(target) {
			case 'export-to-excel' :
			jQuery('#hidden-type').val(target);
			//alert($('#hidden-type').val());
			jQuery('#export-form').submit();
			jQuery('#hidden-type').val('');
			break
		}
		});
    });



	jQuery('.save-line-product').on('click', function(){
       	jQuery('.m_lineloader').css('display','block');
       	var product = jQuery(this).data('product');
       
       	var regular_price  = jQuery('.m_regular_price_' + product).val();
       	var sales_price    = jQuery('.m_sales_price_' + product).val();
       	var weight         = jQuery('.weight_' + product).val();
       	var manage_stock   = jQuery('.m_manage_stock_' + product).val();
       	var stock_status   = jQuery('.m_stock_status_' + product).val();
       	var stock          = jQuery('.m_stock_' + product).val();
       	var secure         = jQuery('.msm-ajax-nonce_' + product).val();

       	var data = {
        	action         : 'motif_save_one_product',
            product        : product,
            manage_stock   : manage_stock,
            stock_status   : stock_status,
            stock          : stock,
            regular_price  : regular_price,
            sales_price    : sales_price,
            weight 		   : weight,
            secure         : secure
       	};

        jQuery.post(ajaxurl, data, function(response){
          	jQuery('.m_lineloader').css('display','none'); 
        
        });
       
    });

	// sorting filtringin
	function m_srotingstock_p(id) { 
	
		var ajaxurl = "<?php echo admin_url( 'admin-ajax.php'); ?>";
		var condition = 'motif_stocksort_condition';
		jQuery.ajax({
			url : ajaxurl,
			type : 'post',
			data : {
				action : 'motif_stocksort_action',
				condition :condition,
				id : id
				
			},
			success : function( response ) {
				jQuery('#msm_mbody').html(response);
			}
		});
	}

	//Open box for product type variation saving
	jQuery('.mo_protype .dashicons').on('click', function(){      
        var item = jQuery(this).data('item');
        jQuery('.item-type-wrap-'+item).css('display','block');
    });

    jQuery('.item-type-wrap-button-close').on('click', function(){
        jQuery(this).parent().parent().css('display', 'none');
    });

    jQuery('.item-post-tpe-button').on('click', function(ajax_object){
    	var item = jQuery(this).data('item');
    	var formData = jQuery("#product-varition"+item).serialize();
        // var title = jQuery('.item-post-title-'+item).val();
        var data = {
            action  : 'motif_product_variation_save',
            item    : item,
            formData   : formData,
            secure  : ajax_object.ajax_nonce
        };
        jQuery.post(ajaxurl, data, function(response){   
            location.reload();
            // console.log(response);
        });
    });

	//Open box for product title saving
    jQuery('.mo_proname .dashicons').on('click', function(){      
        var item = jQuery(this).data('item');
        jQuery('.item-post-title-wrap-'+item).css('display','block');
    });

    jQuery('.item-post-title-button-close').on('click', function(){
        jQuery(this).parent().css('display', 'none');
    });

    //Save product title
    jQuery('.item-post-title-button').on('click', function(ajax_object){
       
        var item = jQuery(this).data('item');
        var title = jQuery('.item-post-title-'+item).val();
        var data = {
            action  : 'motif_product_title_save',
            item    : item,
            title   : title,
            secure  : ajax_object.ajax_nonce
        };
        jQuery('.item-post-title-'+item).val(title); 
        jQuery('.item-post-link-'+item).text(title);  
        
        jQuery.post(ajaxurl, data, function(response, item, title){   
            jQuery('.item-post-title-wrap-'+response).css('display', 'none');
        });
        
    });

    //Open box for sku saving
    jQuery('.mo_prosku .dashicons').on('click', function(){      
        var item = jQuery(this).data('item');
        jQuery('.item-sku-wrap-'+item).css('display','block');
    });
    //Close box for sku saving
    jQuery('.item-sku-button-close').on('click', function(){
        jQuery(this).parent().css('display', 'none');
    });
    // //Save sku
    jQuery('.item-sku-button').on('click', function(ajax_object){
       
        var item = jQuery(this).data('item');
        var sku = jQuery('.sku_'+item).val();
        var data = {
            action  : 'motif_sku_saving',
            item    : item,
            sku     : sku,
            secure  : ajax_object.ajax_nonce
        };
        jQuery('.sku_-'+item).val(sku); 
        jQuery('.item-sku-text-'+item).text(sku);  
        
        jQuery.post(ajaxurl, data, function(response, item, sku){   
            jQuery('.item-sku-wrap-'+response).css('display', 'none');      
        });
        
    });

    // pagination
	jQuery(function() {
	    jQuery("div.holder").jPages({
	      containerID: "msm_mbody",
	      previous : "«",
	      next : "»",
	      perPage: <?php echo $setings['per_page_product']; ?>,
	      minHeight : false,
	      animation : "",
	    });
	});
</script>